package com.ejie.ab04b.service.tramitacion;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesDocumentos;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.ConstantesPlateaTramitacion;
import com.ejie.ab04b.constantes.ConstantesServicioCorrespondencia;
import com.ejie.ab04b.constantes.TipoDocumentoEnum;
import com.ejie.ab04b.constantes.TipoTareaFlujo;
import com.ejie.ab04b.constantes.TipoTareaPlatea;
import com.ejie.ab04b.constantes.TipoTramiteFlujo;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.EstudioDocOS3;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.ab04b.model.Venviospostales;
import com.ejie.ab04b.service.DatosEnvioPostalService;
import com.ejie.ab04b.service.DatosLocalizacionService;
import com.ejie.ab04b.service.DatosNotificacionService;
import com.ejie.ab04b.service.DocumentoOS3Service;
import com.ejie.ab04b.service.GeneracionPDFSubsanacionService;
import com.ejie.ab04b.service.OS3Service;
import com.ejie.ab04b.service.TipoDocumentoService;
import com.ejie.ab04b.service.TramiteOS3Service;
import com.ejie.ab04b.service.TramiteService;
import com.ejie.ab04b.service.VenviospostalesService;
import com.ejie.ab04b.service.dokusi.DokusiService;
import com.ejie.ab04b.service.pif.PifService;
import com.ejie.ab04b.service.platea.PlateaTramitacionService;
import com.ejie.ab04b.service.serviciocorrespondencia.ServicioCorrespondenciaService;
import com.ejie.ab04b.util.PlateaTramitacionUtils;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.ServicioCorrespondenciaUtils;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ab04b.webservice.client.aa66.ErrorWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaOutWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaWs;
import com.ejie.mbt.xml.DeliveredNotificationTaskData;
import com.ejie.mbt.xml.Documents;
import com.ejie.mbt.xml.NotifyTaskData;
import com.ejie.mbt.xml.ObjectFactory;
import com.ejie.mbt.xml.StoredocumentTaskData;
import com.ejie.mbt.xml.StudyTaskData;
import com.ejie.mbt.xml.Task;
import com.ejie.t65.jaxb.beans.fsd.T65BDocumentIDType;

/**
 * @author GFI-NORTE
 * 
 */
@Service(value = "tramitacionOS3Service")
public class TramitacionOS3Service {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(TramitacionOS3Service.class);

	@Autowired()
	private OS3Service oS3ervice;
	@Autowired()
	private DatosNotificacionService datosNotificacionService;
	@Autowired
	private DatosLocalizacionService datosLocalizacionService;
	@Autowired()
	private TramiteOS3Service tramiteOS3Service;
	@Autowired()
	private TramiteService tramiteService;
	@Autowired()
	private DocumentoOS3Service documentoOS3Service;
	@Autowired()
	private TipoDocumentoService tipoDocumentoService;
	@Autowired()
	private DatosEnvioPostalService datosEnvioPostalService;
	@Autowired
	private VenviospostalesService venviospostalesService;

	@Autowired()
	private PlateaTramitacionService plateaTramitacionService;
	@Autowired()
	private DokusiService dokusiService;
	@Autowired()
	private PifService pifService;
	@Autowired()
	private ServicioCorrespondenciaService servicioCorrespondenciaService;
	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private GeneracionPDFSubsanacionService generacionPDFSubsanacionService;

	/**
	 * estudio EstudioDocOS3.
	 * 
	 * @param estudio
	 *            the estudio
	 */
	public void tramitarEstudioDocumentacion(EstudioDocOS3 estudio) {

		TareaOS3 tarea = estudio.getTareaOS3();

		// Preparamos la tarea
		Task task = this.plateaTramitacionService.prepararTarea(
				tarea.getMailboxTaskId096(), TipoTareaPlatea.ESTDOCU);

		// Indicamos los datos propios de la tarea
		StudyTaskData studyTaskData = task.getTaskInfo().getStudyTaskData();
		studyTaskData
				.setResptarea(new ObjectFactory().createStudyTaskDataResptarea(
						UtilSeguridad.getInstance().getNif()));

		if (Constantes.ESTUDIO_DOC_RESULT_OK
				.equals(estudio.getResultado044())) {
			studyTaskData.setSituacionID(Constantes.ESTUDIO_DOC_CDT_RESULT_OK);
		} else if (Constantes.ESTUDIO_DOC_RESULT_REQ
				.equals(estudio.getResultado044())) {
			studyTaskData.setSituacionID(Constantes.ESTUDIO_DOC_CDT_RESULT_REQ);
		}
		studyTaskData
				.setAccion(ConstantesPlateaTramitacion.ESTDOC_ACCION_GRABAR);

		// Añadimos las notas del estudio al task
		task.setObservations(estudio.getNotas044());

		// Lanzamos la ejecución de la tarea
		this.plateaTramitacionService.estudiarDocumentacion(task);

	}

	/**
	 * tarea TareaOS3.
	 * 
	 * @param tarea
	 *            the tarea
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public void prepararDocRequerimiento(TareaOS3 tarea) throws AB04BException {
		try {

			// Obtenemos el tramite de OS3 para obtener la apertura
			TramiteOS3 tramiteRequerimiento = this.tramiteOS3Service
					.find(tarea.getTramiteOS3());

			// Obtenemos el tramite estudio de OS3 para sacar su id interno
			Tramite tipoTramiteEstudio = this.tramiteService
					.findByProceedingIdProcedureId(
							TipoTramiteFlujo.ESTUDIO.name(),
							Utilities.getInstance().obtenerProcedureIdOs3());

			// Obtenemos el último tramite de OS3 de tipo estudio

			TramiteOS3 tramiteEstudio = this.tramiteOS3Service
					.findLastTramiteByTipo(tipoTramiteEstudio.getIdTramite089(),
							tramiteRequerimiento.getOs3());
			tramiteEstudio.toString(); // para que no de error

			String foldernumber = tarea.getTramiteOS3().getOs3()
					.getNumExpediente();

			InputStream is = this.generacionPDFSubsanacionService.getPDF(
					foldernumber, ConstantesDocumentos.COMUNICACION_OS3,
					tramiteRequerimiento.getIdTramite095());

			// Lo subimos a PIF

			String rutaDokusi = this.appConfiguration.getProperty(
					PropertiesUtil.PIF_RUTA_DOKUSI) + "/requerimiento.pdf";
			String rutaDoc = this.pifService.uploadDocument(is, rutaDokusi,
					false);

			DocumentoOS3 documento = this.crearDocumentoAdjuntar(
					TipoDocumentoEnum.REQUERIMIENTO,
					Constantes.NOM_FICH_REQ_PDF, rutaDoc,
					tarea.getTramiteOS3());

			this.prepararDocTramitar(tarea, documento);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * tipoDocumentoEnum TipoDocumentoEnum nombreDoc String rutaPif String
	 * tramite TramiteOS3 DocumentoOS3.
	 * 
	 * @param tipoDocumentoEnum
	 *            the tipo documento enum
	 * @param nombreDoc
	 *            the nombre doc
	 * @param rutaPif
	 *            the ruta pif
	 * @param tramite
	 *            the tramite
	 * @return the documento OS 3
	 */
	private DocumentoOS3 crearDocumentoAdjuntar(
			TipoDocumentoEnum tipoDocumentoEnum, String nombreDoc,
			String rutaPif, TramiteOS3 tramite) {

		TipoDocumento tipoDocumento = new TipoDocumento(
				tipoDocumentoEnum.getIdTipoDoc());
		tipoDocumento = this.tipoDocumentoService.find(tipoDocumento);

		DocumentoOS3 documento = new DocumentoOS3();
		documento.setNombreDoc097(nombreDoc);
		documento.setOrigen097(Constantes.DOCUMENTO_ORIGEN_ADMINISTRACION);
		documento.setRutaPif097(rutaPif);
		documento.setTipoDocumento(tipoDocumento);
		documento.setFechaDoc097(new Date());
		documento.setTramiteOS3(tramite);
		documento.setFormatoAport097(Constantes.FORMATO_APORTACION_ELECTRONICO);

		return documento;
	}

	/**
	 * Sube el documento de la tramitación a Dokusi, lo guarda en BD y solicita
	 * su transformación a PDFA
	 * 
	 * tarea TareaOS3 documento DocumentoOS3.
	 * 
	 * @param tarea
	 *            the tarea
	 * @param documento
	 *            the documento
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private void prepararDocTramitar(TareaOS3 tarea, DocumentoOS3 documento)
			throws AB04BException {// TODO metodo
									// trampeado porque
									// no funciona la
									// subida a Dokusi
		try {
			// Lo subimos a Dokusi
			T65BDocumentIDType t65BDocumentIDType = this.dokusiService
					.almacenarDocumento(
							UtilSeguridad.getInstance().getAuditUserAuto(),
							documento);

			// Guardamos su OID
			documento.setOidDokusi097(t65BDocumentIDType.getId());

			// Guardamos el Id de la tarea que deberá continuar cuando recibamos
			// la confirmación de transformación a PDFA
			documento.setTareaOS3Continuar(tarea);

			// Persistimos en BD
			DocumentoOS3 documentoAux = this.documentoOS3Service.add(documento);

			// Solicitamos su transformación a PDFA
			this.dokusiService.transformarPDFA(
					UtilSeguridad.getInstance().getAuditUserAuto(),
					t65BDocumentIDType);

			TramitacionOS3Service.LOGGER.info(
					"Se ha subido el documento {} a Dokusi, con OID {} y se ha solicitado su transformación a PDFA",
					documentoAux.getIdDocumento097(),
					documentoAux.getOidDokusi097());

		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * tarea TareaOS3 documento Long.
	 * 
	 * @param tarea
	 *            the tarea
	 * @param documento
	 *            the documento
	 */
	public void tramitarAdjuntarDoc(TareaOS3 tarea, DocumentoOS3 documento) {

		// Preparamos la tarea
		Task task = this.plateaTramitacionService.prepararTarea(
				tarea.getMailboxTaskId096(), TipoTareaPlatea.APORDOCU);

		// Indicamos los datos propios de la tarea
		StoredocumentTaskData storedocumentTaskData = task.getTaskInfo()
				.getStoredocumentTaskData();

		String taskId = tarea.getTipoTarea().getTaskId090();

		if (TipoTareaFlujo.ADJUNTAR_INFORME.esEquivalente(taskId)) {
			// Sender
			storedocumentTaskData.setSenderManagingUnitID(
					Utilities.getInstance().obtenerManagingunitIdOsalan());
			storedocumentTaskData.setSenderManagingUnitName(
					PlateaTramitacionUtils.getInstance()
							.obtenerManagingunitNameDescriptionOsalan());
			storedocumentTaskData.setSenderDepartmentID(
					Utilities.getInstance().obtenerDepartmentIdOsalan());
			storedocumentTaskData.setSenderDepartmentName(PlateaTramitacionUtils
					.getInstance().obtenerDepartmentNameDescriptionOsalan());
			storedocumentTaskData.setSenderOrganismID(
					Utilities.getInstance().obtenerOrganismIdOsalan());
			storedocumentTaskData.setSenderOrganismName(PlateaTramitacionUtils
					.getInstance().obtenerOrganismNameDescriptionOsalan());

			storedocumentTaskData.setInternalExternal(
					ConstantesPlateaTramitacion.APORTACION_EXTERNAL);
		} else {
			// Sender
			storedocumentTaskData.setSenderManagingUnitID(
					Utilities.getInstance().obtenerManagingunitId());
			storedocumentTaskData.setSenderManagingUnitName(
					PlateaTramitacionUtils.getInstance()
							.obtenerManagingunitNameDescription());
			storedocumentTaskData.setSenderDepartmentID(
					Utilities.getInstance().obtenerDepartmentId());
			storedocumentTaskData.setSenderDepartmentName(PlateaTramitacionUtils
					.getInstance().obtenerDepartmentNameDescription());
			storedocumentTaskData.setSenderOrganismID(
					Utilities.getInstance().obtenerOrganismId());
			storedocumentTaskData.setSenderOrganismName(PlateaTramitacionUtils
					.getInstance().obtenerOrganismNameDescription());

			storedocumentTaskData.setInternalExternal(
					ConstantesPlateaTramitacion.APORTACION_INTERNAL);
		}

		// Receiver
		storedocumentTaskData.setReceiverManagingUnitID(
				Utilities.getInstance().obtenerManagingunitId());
		storedocumentTaskData.setReceiverManagingUnitName(PlateaTramitacionUtils
				.getInstance().obtenerManagingunitNameDescription());
		storedocumentTaskData.setReceiverDepartmentID(
				Utilities.getInstance().obtenerDepartmentId());
		storedocumentTaskData.setReceiverDepartmentName(PlateaTramitacionUtils
				.getInstance().obtenerDepartmentNameDescription());
		storedocumentTaskData.setReceiverOrganismID(
				Utilities.getInstance().obtenerOrganismId());
		storedocumentTaskData.setReceiverOrganismName(PlateaTramitacionUtils
				.getInstance().obtenerOrganismNameDescription());

		storedocumentTaskData.setStoreDate(PlateaTramitacionUtils.getInstance()
				.formatearTimestampPlatea(documento.getFechaDoc097()));
		storedocumentTaskData
				.setEntityID(Utilities.getInstance().obtenerEntityId());

		storedocumentTaskData.getDocuments().getDocument()
				.add(PlateaTramitacionUtils.getInstance()
						.construirDocument(documento));

		// Lanzamos la ejecución de la tarea
		this.plateaTramitacionService.aportarDocumentacion(task);

	}

	/**
	 * task Task tramite TramiteOS3 tarea TareaOS3 tipoTramite TipoTramiteFlujo.
	 * 
	 * @param task
	 *            the task
	 * @param tramite
	 *            the tramite
	 * @param tarea
	 *            the tarea
	 * @param tipoTramite
	 *            the tipo tramite
	 */
	public void processEnviarNotificacion(Task task, TramiteOS3 tramite,
			TareaOS3 tarea, TipoTramiteFlujo tipoTramite) {

		OS3 os3 = this.oS3ervice.find(tramite.getOs3());
		DatosNotificacion datosNotif = this
				.obtenerDatosNotificacionDestinatario(os3, tipoTramite);

		String[] datosDestinatario = this.obtenerDatosDestinatario(os3,
				tipoTramite);

		// Ya hemos preparado la tarea antes en SvtService.process()

		// Indicamos los datos propios de la tarea
		NotifyTaskData notifyTaskData = task.getTaskInfo().getNotifyTaskData();

		notifyTaskData = PlateaTramitacionUtils.getInstance()
				.rellenarDatosBasicosNotification(notifyTaskData, datosNotif,
						datosDestinatario[0], datosDestinatario[1]);

		notifyTaskData = this.rellenarNotificationInfo(notifyTaskData,
				tipoTramite);

		List<DocumentoOS3> listaDocumentos = this.obtenerDocumentos(tipoTramite,
				tarea);
		notifyTaskData = this.rellenarDocumentos(notifyTaskData,
				listaDocumentos);

		// Lanzamos la ejecución de la tarea
		this.plateaTramitacionService.enviarComunicacion(task);

	}

	/**
	 * os3 ComunicacionApertura tipoTramite TipoTramiteFlujo DatosNotificacion.
	 * 
	 * @param os3
	 *            the os 3
	 * @param tipoTramite
	 *            the tipo tramite
	 * @return the datos notificacion
	 */
	private DatosNotificacion obtenerDatosNotificacionDestinatario(OS3 os3,
			TipoTramiteFlujo tipoTramite) {

		DatosNotificacion datosNotificacion = null;
		if (TipoTramiteFlujo.REQUERIMIENTO.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_CONTRATISTA.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_OS2.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_OS2OS3.equals(tipoTramite)
				|| TipoTramiteFlujo.CAMBIAR_COORDINADOR.equals(tipoTramite)) {
			datosNotificacion = this.datosNotificacionService
					.find(os3.getDatosNotificacion());
		}

		return datosNotificacion;
	}

	/**
	 * Devuelve en la posición 0 el Nif/Cif del destinatario y en la posición 1
	 * el Nombre/Razón Social del destinatario
	 * 
	 * os3 ComunicacionApertura tipoTramite TipoTramiteFlujo String[].
	 * 
	 * @param os3
	 *            the os 3
	 * @param tipoTramite
	 *            the tipo tramite
	 * @return the string[]
	 */
	private String[] obtenerDatosDestinatario(OS3 os3,
			TipoTramiteFlujo tipoTramite) {

		// TODO falta poner el nombre y cif real del destinatario
		String[] datosDestinatario = new String[ConstantesNum.NUM_2];

		if (TipoTramiteFlujo.REQUERIMIENTO.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_CONTRATISTA.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_OS2.equals(tipoTramite)
				|| TipoTramiteFlujo.COMUNICACION_OS2OS3.equals(tipoTramite)
				|| TipoTramiteFlujo.CAMBIAR_COORDINADOR.equals(tipoTramite)) {

			if (os3.getNumdocrepresentante061() != null) {
				datosDestinatario[0] = os3.getNumdocrepresentante061();
				datosDestinatario[1] = os3.getNomrepresentante061();

			} else {
				datosDestinatario[0] = os3.getNumdoc061();
				datosDestinatario[1] = os3.getNomemp061();
			}

			if (TipoTramiteFlujo.COMUNICACION_CONTRATISTA.equals(tipoTramite)
					|| TipoTramiteFlujo.CAMBIAR_COORDINADOR
							.equals(tipoTramite)) {
				// Añadimos (Att. contratista) al nombre
				StringBuilder sb = new StringBuilder(datosDestinatario[1]);
				sb.append(Constantes.DEST_CARTA_CONTRATISTA);
				datosDestinatario[1] = sb.toString();
			}
		}

		return datosDestinatario;
	}

	/**
	 * task Task tramite TramiteOS3 tarea TareaOS3 tipoTramite TipoTramiteFlujo.
	 * 
	 * @param task
	 *            the task
	 * @param tramite
	 *            the tramite
	 * @param tarea
	 *            the tarea
	 * @param tipoTramite
	 *            the tipo tramite
	 * @throws Exception
	 */
	public void processRegistrarComunicacionPostal(Task task,
			TramiteOS3 tramite, TareaOS3 tarea, TipoTramiteFlujo tipoTramite)
			throws Exception {

		OS3 apertura = this.oS3ervice.find(tramite.getOs3());
		DatosNotificacion datosNotif = this
				.obtenerDatosNotificacionDestinatario(apertura, tipoTramite);

		apertura.setDatosNotificacion(datosNotif);

		DatosLocalizacion datosLocalizacion = this.datosLocalizacionService
				.find(new DatosLocalizacion(datosNotif.getDatosLocalizacion()
						.getCodLocalizacion067()));

		apertura.getDatosNotificacion().setDatosLocalizacion(datosLocalizacion);

		List<DocumentoOS3> listaDocumentos = this.obtenerDocumentos(tipoTramite,
				tarea);

		if (TipoTramiteFlujo.REQUERIMIENTO.equals(tipoTramite)) {
			// Cargamos el envío a la aplicación de Servicio de Correspondencia

			DocumentoOS3 documento = listaDocumentos.get(0);
			documento.getTramiteOS3().setOs3(apertura);

			RemesaWs remesaEntrada = ServicioCorrespondenciaUtils.getInstance()
					.construirRemesaWs(documento, apertura.getUsuarioTram061());
			RemesaOutWs remesaResult = this.servicioCorrespondenciaService
					.cargaMasiva(remesaEntrada);

			if (remesaResult.getErrores() == null
					|| remesaResult.getErrores().isEmpty()) {
				// Guardamos el resultado de la carga
				DatosEnvioPostal datosEnvioPostal = ServicioCorrespondenciaUtils
						.getInstance().construirDatosEnvioPostal(remesaResult);
				datosEnvioPostal.setEstadoEnvio069(
						ConstantesServicioCorrespondencia.ESTADO_ENVIO_PTE_IMPRESION);
				datosEnvioPostal = this.datosEnvioPostalService
						.add(datosEnvioPostal);
				documento.setDatosEnvioPostal(datosEnvioPostal);
				this.documentoOS3Service.updateFilled(documento);
			} else {
				// Ha habido errores
				TramitacionOS3Service.LOGGER.error(
						"Han ocurrido errores al cargar envío a la remesa");
				for (ErrorWs error : remesaResult.getErrores()) {
					TramitacionOS3Service.LOGGER.error(
							"Descripción error: {} - {}",
							error.getCodigoError(),
							error.getDescripcionCastellano());
				}
			}

		}
		// Ya hemos preparado la tarea antes en SvtService.process()

		// Indicamos los datos propios de la tarea
		NotifyTaskData notifyTaskData = task.getTaskInfo().getNotifyTaskData();

		notifyTaskData = PlateaTramitacionUtils.getInstance()
				.rellenarDatosBasicosNotification(notifyTaskData, datosNotif,
						apertura.getNumdocrepresentante061(),
						apertura.getNomemp061());

		notifyTaskData = this.rellenarNotificationInfo(notifyTaskData,
				tipoTramite);

		notifyTaskData = this.rellenarDocumentos(notifyTaskData,
				listaDocumentos);

		// Lanzamos la ejecución de la tarea
		this.plateaTramitacionService.registraComunicacionPostal(task);

	}

	/**
	 * tarea TareaAperturas tramite TramiteAperturas.
	 * 
	 * @param tarea
	 *            the tarea
	 * @param tramite
	 *            the tramite
	 */
	public void tramitarAcuseRequerimiento(TareaOS3 tarea, TramiteOS3 tramite) {

		// Preparamos la tarea
		Task task = this.plateaTramitacionService.prepararTarea(
				tarea.getMailboxTaskId096(), TipoTareaPlatea.RECINOTI);

		OS3 apertura = this.oS3ervice.find(tramite.getOs3());

		Venviospostales venvioPostal = new Venviospostales();
		venvioPostal.setIdTramite(tramite.getIdTramite095());
		venvioPostal.setTipoexp(Constantes.OS3);

		venvioPostal = this.venviospostalesService.findByTipoExp(venvioPostal);

		DatosEnvioPostal datosEnvioPostal = venvioPostal.getDatosEnvioPostal();

		// Indicamos los datos propios de la tarea
		DeliveredNotificationTaskData deliveredNotificationTaskData = task
				.getTaskInfo().getDeliveredNotificationTaskData();

		com.ejie.mbt.xml.DescriptionType notifiedActDescription = null;

		notifiedActDescription = PlateaTramitacionUtils.getInstance()
				.construirMbtDescriptionType(
						this.appMessageSource.getMessage(
								ConstantesPlateaTramitacion.NOT_ACT_NAME_REQ_SUB,
								null, Constantes.LOCALE_ES),
						this.appMessageSource.getMessage(
								ConstantesPlateaTramitacion.NOT_ACT_NAME_REQ_SUB,
								null, Constantes.LOCALE_EU));

		// deliveredNotificationTaskData.setNotificationID();
		deliveredNotificationTaskData.setNotifiedActID(
				ConstantesPlateaTramitacion.NOT_ACT_ID_REQ_SUB);
		deliveredNotificationTaskData
				.setNotifiedActDescription(notifiedActDescription);

		String notificationFormat = PlateaTramitacionUtils.getInstance()
				.obtenerNotificationFormat(
						apertura.getDatosNotificacion().getCanalnotif066());

		deliveredNotificationTaskData.setNotificationFormat(notificationFormat);
		// deliveredNotificationTaskData.setAddresseeID(apertura.getNumdoc056());
		// deliveredNotificationTaskData.setAddresseeName(apertura.getNomemp056());
		deliveredNotificationTaskData
				.setDeliveryPersonID(apertura.getNumdoc061());
		deliveredNotificationTaskData
				.setDeliveryPersonName(apertura.getNomemp061());
		deliveredNotificationTaskData
				.setDeliveryStatus(datosEnvioPostal.getEstadoAcuse069());
		SimpleDateFormat dateFormat = new SimpleDateFormat(
				Constantes.ES_DATE_MASK);

		deliveredNotificationTaskData.setDeliveryTimestamp(
				dateFormat.format(datosEnvioPostal.getFecnotificacion069()));
		deliveredNotificationTaskData.setReceptionTimestamp(
				dateFormat.format(datosEnvioPostal.getFecAcuse069()));

		// Lanzamos la ejecución de la tarea
		this.plateaTramitacionService.acuseRequerimiento(task);
	}

	/**
	 * notifyTaskData NotifyTaskData tipoTramite TipoTramiteFlujo
	 * NotifyTaskData.
	 * 
	 * @param notifyTaskData
	 *            the notify task data
	 * @param tipoTramite
	 *            the tipo tramite
	 * @return the notify task data
	 */
	private NotifyTaskData rellenarNotificationInfo(
			NotifyTaskData notifyTaskData, TipoTramiteFlujo tipoTramite) {

		String notifiedActId = "";
		com.ejie.mbt.xml.DescriptionType notifiedActName = null;
		String notTextEs = "";
		String notTextEu = "";

		if (TipoTramiteFlujo.REQUERIMIENTO.equals(tipoTramite)) {
			notifiedActId = ConstantesPlateaTramitacion.NOT_ACT_ID_REQ_SUB;
			notifiedActName = PlateaTramitacionUtils.getInstance()
					.construirMbtDescriptionType(
							this.appMessageSource.getMessage(
									ConstantesPlateaTramitacion.NOT_ACT_NAME_REQ_SUB,
									null, Constantes.LOCALE_ES),
							this.appMessageSource.getMessage(
									ConstantesPlateaTramitacion.NOT_ACT_NAME_REQ_SUB,
									null, Constantes.LOCALE_EU));

			notTextEs = this.appMessageSource.getMessage(
					PropertiesUtil.NOTTEXT_OS3_REQSUB, null,
					Constantes.LOCALE_ES);
			notTextEu = this.appMessageSource.getMessage(
					PropertiesUtil.NOTTEXT_OS3_REQSUB, null,
					Constantes.LOCALE_EU);
		}

		notifyTaskData.setNotifiedActID(notifiedActId);
		notifyTaskData.setNotifiedActName(notifiedActName);
		notifyTaskData.setNotificationText(PlateaTramitacionUtils.getInstance()
				.construirMbtDescriptionType(notTextEs, notTextEu));

		return notifyTaskData;
	}

	/**
	 * tipoTramite TipoTramiteFlujo tarea TareaOS3 List<DocumentoOS3>.
	 * 
	 * @param tipoTramite
	 *            the tipo tramite
	 * @param tarea
	 *            the tarea
	 * @return the list
	 */
	public List<DocumentoOS3> obtenerDocumentos(TipoTramiteFlujo tipoTramite,
			TareaOS3 tarea) {

		List<DocumentoOS3> listaDocumentos = null;
		DocumentoOS3 documentoFilter = new DocumentoOS3();

		documentoFilter.setTramiteOS3(tarea.getTramiteOS3());
		// TODO Cogemos todos los documentos del trámite. Por ahora no es
		// necesario filtrar por el tipo de documento.
		// if (TipoTramiteFlujo.REQUERIMIENTO.equals(tipoTramite)) {
		// documentoFilter.setTipoDocumento(new TipoDocumento(
		// TipoDocumentoEnum.REQUERIMIENTO.getIdTipoDoc()));
		// }

		listaDocumentos = this.documentoOS3Service.findAll(documentoFilter,
				null);

		return listaDocumentos;
	}

	/**
	 * notifyTaskData NotifyTaskData listaDocumentos List
	 * <DocumentoOS3> NotifyTaskData.
	 * 
	 * @param notifyTaskData
	 *            the notify task data
	 * @param listaDocumentos
	 *            the lista documentos
	 * @return the notify task data
	 */
	private NotifyTaskData rellenarDocumentos(NotifyTaskData notifyTaskData,
			List<DocumentoOS3> listaDocumentos) {

		if (listaDocumentos != null && !listaDocumentos.isEmpty()) {
			Documents documents = new Documents();
			for (DocumentoOS3 doc : listaDocumentos) {
				documents.getDocument().add(PlateaTramitacionUtils.getInstance()
						.construirDocument(doc));
			}
			notifyTaskData.setDocuments(documents);
		}

		return notifyTaskData;
	}

}
